#ifndef __EX94421A_H
#define __EX94421A_H

struct ThreadParameter
{
	bool enable_irq;
	bool ThreadProc;
};

typedef 	char				i8;
typedef 	unsigned char			u8;
typedef 	short				i16;
typedef 	unsigned short			u16;
typedef 	long				i32;
typedef 	unsigned long			u32;
typedef 	float				f32;
typedef 	double				f64;
//******************************************************
#define		_CARD_ID_MAX							15
#define		_NO_CARD							0xFF

#define		EX94421A_AD_CHANNLE_MAX					23


#define		EX94421A_INPORT_MIN						0
#define		EX94421A_INPORT_MAX						1
#define		EX94421A_OUTPORT_MIN					2
#define		EX94421A_OUTPORT_MAX					3
#define		EX94421A_IN_POINT_MAX  					7
#define		EX94421A_OUT_POINT_MAX					7
#define		EX94421A_INDEX_MIN						0
#define		EX94421A_INDEX_MAX						7
#define		EX94421A_DEBOUNCE_MODE_MAX				3

#define		FAIL					0


////////////// Error Code ///////////////////////
#define		NO_ERROR			0

/************ Driver Error ***************/
#define		READ_DATA_ERROR	 	-1
#define		INIT_ERROR			-2
#define		UNLOCK_ERROR			-3	// Driver Error
#define		LOCK_COUNTER_ERROR		-4	// Driver Error
#define		SET_SECURITY_ERROR		-5	// Driver Error

/************ Device Error ***************/
#define		DEVICE_RW_ERROR			-100
#define		NO_CARD			-101
#define		DUPLICATE_ID			-102
#define		NOT_INSTALL			-103

/************ User Parameter Error ********/
#define		ID_ERROR			-300
#define		MODE_ERROR			-301
#define		CHANNEL_ERROR			-302
#define		CONVERSION_ERROR		-305
#define		CONVERSION_BUSY		-306
#define		PORT_ERROR    			-400
#define		TIMERID_ERROR			-406
#define		PARAMETER_ERROR		-409
#define		OPERATION_ERROR		-410

// #define		PORT_ERROR		-301
// #define		IN_POINT_ERROR		-302
#define		OUT_POINT_ERROR		-303
// #define		SOURCE_ERROR		-305
// #define		DEBOUNCE_MODE_ERROR	-306

/************ Time Counter Error ********/
// #define		INDEX_ERROR		-406
#define		TO_mode_ERROR			-407
#define		TI_mode_ERROR			-408

#define		DEBOUNCE_MODE_ERROR		-501

/************ TIMER/COUNTER **********************/
#define		TC_CONTROL				0	//TC_function
#define		TC_MODE				1	
#define		TI_GATE_MODE				2
#define		TO_MODE				3
#define		RETRIGGER_MODE			4
#define		PRELOAD				5
#define		COUNTER				6
#define		OUT_WIDTH				7
#define		MULTIPLE_RATE				8
/************ TC MODE ****************************/
#define		TIMER_MODE			0
#define		COUNTER_MODE			1
#define		SW_DEC				3
#define		PWM_MODE				4
#define		QUADRATURE_MODE			8
/************ To MODE ****************************/
#define		NO_TOUT                         0
#define		OUT_PULSE			1
#define		OUT_LEVEL			2
#define		OUT_TOGGLE			4

/************ DEBOUNCE_TIME *************/
#define		NO_DEBOUNCE_TIME			0	//SET DEBOUNCE_TIME
#define		DEBOUNCE_TIME_100HZ			1
#define		DEBOUNCE_TIME_200HZ			2
#define		DEBOUNCE_TIME_1KHZ			3
#define		TC_DEBOUNCE_0			0
#define		TC_DEBOUNCE_1			1


/************ AD mode *************/
#define		V370_V0_V5				0
#define		V370_V5_V5				1
#define		V370_V0_V10				2
#define		V370_V10_V10				3
#define		STOP_OPERATION			0xFF
//******************V370***********************************
#define	V370_CHANNEL_0				0	//000<<4
#define	V370_CHANNEL_1				1	//100<<4
#define	V370_CHANNEL_2				2	//001<<4
#define	V370_CHANNEL_3				3	//101<<4
#define	V370_CHANNEL_4				4	//010<<4
#define	V370_CHANNEL_5				5	//110<<4
#define	V370_CHANNEL_6				6	//011<<4
#define	V370_CHANNEL_7				7	//111<<4
//
#ifdef __cplusplus
	extern "C"{
#endif

//********* T/C****************	20080922
typedef struct Timer_struct
{
	u8 Ti_Gate_MODE;
	//  0: NO_GATE //Always count without gate function,
	//IN00 is digital input.
	//IN01 is digital input.
	//  1:GATED
	//IN00 is gate input, after command start_TC,
	//if internal logic active high timer will start 
	//counting and logic low will halt counting.
	//in01 is digital input.
	//  2:EDGE_START 
	//IN00 is gate input after command start_TC
	//if internal logic active high will start timer
	//IN01 is digital input
	u32 time_const;
	// Timer constant based on 1us clock
	u8 Tout_mode;
	//  0: NO_TOUT ,
	//OUT00 use as general digital output
	//  1: OUT_PULSE 
	//OUT00:timer cross zero output pulse. 
	//(out_width effective)
	//  2: OUT_LEVEL 
	//OUT00: timer cross zero output will make.
	//  4:OUT_TOGGLE 
	//OUT00: timer cross zero toggles output
	u16 Tout_width;
	// Output pulse width based on 1us clock, only
	//valid in Tout_mode is OUT_PULSE
	u8 cont_single;
	//  0: SINGLE_CYCLE
	//single cycle mode,timer will stop operation
	//when time constant count down to zero.
	//  1: ALWAYS_RUN
	//continuous operation mode, timer will reload 
	//time constant and continue operation when 
	//time constant count down to zero.
}T_struct;
typedef struct Counter_struct
{
	u8 Ti_Gate_MODE;
	// 0:NO_GATE
	//Always count without gate function.
	//IN00 is digital input.
	//IN01 is counter pulse input
	// 1:GATED
	//IN00 is gate input,internal logic active high
	//will start to pass the counter Ti pulse to counter
	//after command start_TC
	//IN01 is counter pulse input(Ti)
	// 2:EDGE_START
	//IN00 is gate input,internal logic active high
	//will start to pass the counter Ti pulse to counter
	//after command start_TC
	//IN01 is counter pulse input(Ti)

	u32 counter_const;
	// Counter constant
	u8 Tout_mode;
	//  0: NO_TOUT 
	// OUT00 use as general digital output
	//  1: OUT_PULSE //OUT00: timer cross zero output pulse.
	//(out_width effective)
	//  2: OUT_LEVEL 
	//OUT00: timer cross zero output will make.
	//  4:OUT_TOGGLE //OUT00: timer cross zero toggles output

	u16 Tout_width;
	// Output pulse width based on 1us clock, only
	//valid in Tout_mode is OUT_PULSE
	u8 cont_single;
	//  0: SINGLE_CYCLE
	//single cycle mode, counter will stop operation 
	//when time constant count down to zero.
	//  1: ALWAYS_RUN
	// continuous operation mode, counter will reload  
	//time constant and continue operation when time  
	//constant count down to zero.
}C_struct;
typedef struct PWM_struct
{
	u8 Ti_Gate_MODE;
	//  0: NO_GATE //Always count without gate function,
	//IN00 is digital input.
	//IN01 is digital input.
	//  1:GATED
	//IN00 is gate input, after command start_TC,
	//if internal logic active high timer will start 
	//counting and logic low will halt counting.
	//in01 is digital input.
	//  2:EDGE_START 
	//IN00 is gate input after command start_TC
	//if internal logic active high will start timer
	//IN01 is digital input
	//u8 Tout_mode;
	//  0: NO_TOUT
	// OUT00 use as general digital output
	//  4:OUT_TOGGLE 
	//OUT00: timer cross zero toggles output
	u16 PWM_freq;
	u16 PWM_duty;	
}PWM_struct;
		
#define EX94421A_Status	extern i32

/********************* DLL Function ********************************/
EX94421A_Status EX94421A_initial();
EX94421A_Status EX94421A_close();
EX94421A_Status EX94421A_info(u8 CardID, u16 *address);

EX94421A_Status EX94421A_initial_calibration(u8 CardID);
/********************************************************************************/
EX94421A_Status EX94421A_AD_config_set(u8 CardID,u8 channel,u8 mode);
EX94421A_Status EX94421A_AD_config_read(u8 CardID,u8 channel,u8 *mode);
EX94421A_Status EX94421A_AD_value_read(u8 CardID,u8 channel,f32 *value);
EX94421A_Status EX94421A_AD_value_read_no_calibration (u8 CardID,u8 channel,f32 *value);
EX94421A_Status EX94421A_AD_data_read_no_calibration (u8 CardID,u8 channel,u16 *data);
EX94421A_Status EX94421A_AD_integral_start(u8 CardID,u8 mode);
EX94421A_Status EX94421A_AD_integral_all_read(u8 CardID,u16 data[24]);
EX94421A_Status EX94421A_AD_integral_stop(u8 CardID);
/********************************************************************************/
EX94421A_Status EX94421A_TTL_IO_config_set (u8 CardID, u8 port, u8 configuration);
EX94421A_Status EX94421A_TTL_IO_config_read (u8 CardID, u8 port, u8 *configuration);
EX94421A_Status EX94421A_TTL_IO_port_set (u8 CardID,u8 port, u8 data);
EX94421A_Status EX94421A_TTL_IO_port_read (u8 CardID , u8 port , u8 *data);
EX94421A_Status EX94421A_TTL_IO_point_set (u8 CardID, u8 port, u8 point, u8 state);
EX94421A_Status EX94421A_TTL_IO_point_read (u8 CardID, u8 port, u8 point, u8 *state);
EX94421A_Status EX94421A_TTL_IO_debounce_time_set (u8 CardID,u8 port ,u8 debounce_time);
EX94421A_Status EX94421A_TTL_IO_debounce_time_read (u8 CardID,u8 port , u8 *debounce_time);
/********************************************************************************/
EX94421A_Status EX94421A_timer_set (u8 CardID,u8 TimerID, Timer_struct *TC_struct);
EX94421A_Status EX94421A_counter_set (u8 CardID,u8 TimerID, Counter_struct *TC_struct);
EX94421A_Status EX94421A_PWM_set (u8 CardID,u8 TimerID, PWM_struct *PWM_struct);
EX94421A_Status EX94421A_quadrature_set(u8 CardID,u8 TimerID,u8 Multiple_rate);
EX94421A_Status EX94421A_TC_start(u8 CardID,u8 TimerID);
EX94421A_Status EX94421A_TC_stop(u8 CardID,u8 TimerID);

EX94421A_Status EX94421A_TC_set(u8 CardID,u8 TimerID,u8 index,u32 data);  
EX94421A_Status EX94421A_TC_read(u8 CardID,u8 TimerID,u8 index,u32 *data);

EX94421A_Status EX94421A_TC_input_polarity_set (u8 CardID,u8 TimerID,u8 input,u8 polarity) ;
EX94421A_Status EX94421A_TC_input_polarity_read (u8 CardID,u8 TimerID,u8 input,u8 *polarity ) ;
EX94421A_Status EX94421A_TC_output_polarity_set (u8 CardID,u8 TimerID,u8 polarity) ;
EX94421A_Status EX94421A_TC_output_polarity_read (u8 CardID,u8 TimerID,u8 *polarity ) ;
/********************************************************************************/
EX94421A_Status EX94421A_IRQ_enable(u8 CardID/*,HANDLE *phEvent*/);
EX94421A_Status EX94421A_IRQ_process_link	(u8 CardID,void ( *callbackAddr)(u8 CardID));
EX94421A_Status EX94421A_IRQ_disable(u8 CardID);
EX94421A_Status EX94421A_IRQ_status_read(u8 CardID, u16 * state);

EX94421A_Status EX94421A_IRQ_mask_set(u8 CardID,u16 mask);
EX94421A_Status EX94421A_IRQ_mask_read(u8 CardID,u16 *mask);
EX94421A_Status EX94421A_IRQ_IO_polarity_set (u8 CardID, u8 polarity);
EX94421A_Status EX94421A_IRQ_IO_polarity_read (u8 CardID, u8 * polarity);
/********************************************************************************/

EX94421A_Status EX94421A_security_status_read(u8 CardID,u8 *lock_status,u8 *seurity_enable);
EX94421A_Status EX94421A_security_unlock(u8 CardID,u16 password[5]);
EX94421A_Status EX94421A_password_set(u8 CardID,u16 password[5]);	
EX94421A_Status EX94421A_password_change(u8 CardID,u16 Oldpassword[5],u16 Password[5]);
EX94421A_Status EX94421A_password_clear(u8 CardID,u16 Password[5]);	

/**************************************************************************************/

#ifdef __cplusplus
	}
#endif


#endif  // belongs to #ifndef __EX94421A_H#ifndef __cplusepluse

